<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xhtml="http://www.w3.org/1999/xhtml"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    version="1.0">
  <xsl:output method="xml"/>

  <xsl:template match="/">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
      <fo:layout-master-set>
        <fo:simple-page-master page-height="4.82in" page-width="3.57in" master-name="default">
          <fo:region-body  />
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:declarations>
        <x:xmpmeta xmlns:x="adobe:ns:meta/">
          <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
            <rdf:Description rdf:about=""
                             xmlns:dc="http://purl.org/dc/elements/1.1/">
              <dc:title>Structure and Interpretation of Computer Programs</dc:title>
              <dc:creator>Harold Ableson and Gerald Jay Sussman with Julie Sussman</dc:creator>
            </rdf:Description>
          </rdf:RDF>
        </x:xmpmeta>
      </fo:declarations>
      <fo:bookmark-tree>
        <fo:bookmark internal-destination="toc_chap_Temp_2">
          <fo:bookmark-title>Foreword</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_Temp_3">
          <fo:bookmark-title>Preface to the Second Edition</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_Temp_4">
          <fo:bookmark-title>Preface to the First Edition</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_Temp_5">
          <fo:bookmark-title>Acknowledgments</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_1">
          <fo:bookmark-title>1  Building Abstractions with Procedures</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1">
          <fo:bookmark-title>1.1  The Elements of Programming</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.1">
          <fo:bookmark-title>1.1.1  Expressions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.2">
          <fo:bookmark-title>1.1.2  Naming and the Environment</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.3">
          <fo:bookmark-title>1.1.3  Evaluating Combinations</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.4">
          <fo:bookmark-title>1.1.4  Compound Procedures</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.5">
          <fo:bookmark-title>1.1.5  The Substitution Model for Procedure Application</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.6">
          <fo:bookmark-title>1.1.6  Conditional Expressions and Predicates</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.7">
          <fo:bookmark-title>1.1.7  Example: Square Roots by Newton's Method</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.1.8">
          <fo:bookmark-title>1.1.8  Procedures as Black-Box Abstractions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.2">
          <fo:bookmark-title>1.2  Procedures and the Processes They Generate</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.2.1">
          <fo:bookmark-title>1.2.1  Linear Recursion and Iteration</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.2.2">
          <fo:bookmark-title>1.2.2  Tree Recursion</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.2.3">
          <fo:bookmark-title>1.2.3  Orders of Growth</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.2.4">
          <fo:bookmark-title>1.2.4  Exponentiation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.2.5">
          <fo:bookmark-title>1.2.5  Greatest Common Divisors</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.2.6">
          <fo:bookmark-title>1.2.6  Example: Testing for Primality</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.3">
          <fo:bookmark-title>1.3  Formulating Abstractions with Higher-Order Procedures</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.3.1">
          <fo:bookmark-title>1.3.1  Procedures as Arguments</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.3.2">
          <fo:bookmark-title>1.3.2  Constructing Procedures Using</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.3.3">
          <fo:bookmark-title>1.3.3  Procedures as General Methods</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_1.3.4">
          <fo:bookmark-title>1.3.4  Procedures as Returned Values</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_2">
          <fo:bookmark-title>2  Building Abstractions with Data</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.1">
          <fo:bookmark-title>2.1  Introduction to Data Abstraction</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.1.1">
          <fo:bookmark-title>2.1.1  Example: Arithmetic Operations for Rational Numbers</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.1.2">
          <fo:bookmark-title>2.1.2  Abstraction Barriers</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.1.3">
          <fo:bookmark-title>2.1.3  What Is Meant by Data?</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.1.4">
          <fo:bookmark-title>2.1.4  Extended Exercise: Interval Arithmetic</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.2">
          <fo:bookmark-title>2.2  Hierarchical Data and the Closure Property</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.2.1">
          <fo:bookmark-title>2.2.1  Representing Sequences</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.2.2">
          <fo:bookmark-title>2.2.2  Hierarchical Structures</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.2.3">
          <fo:bookmark-title>2.2.3  Sequences as Conventional Interfaces</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.2.4">
          <fo:bookmark-title>2.2.4  Example: A Picture Language</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.3">
          <fo:bookmark-title>2.3  Symbolic Data</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.3.1">
          <fo:bookmark-title>2.3.1  Quotation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.3.2">
          <fo:bookmark-title>2.3.2  Example: Symbolic Differentiation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.3.3">
          <fo:bookmark-title>2.3.3  Example: Representing Sets</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.3.4">
          <fo:bookmark-title>2.3.4  Example: Huffman Encoding Trees</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.4">
          <fo:bookmark-title>2.4  Multiple Representations for Abstract Data</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.4.1">
          <fo:bookmark-title>2.4.1  Representations for Complex Numbers</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.4.2">
          <fo:bookmark-title>2.4.2  Tagged data</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.4.3">
          <fo:bookmark-title>2.4.3  Data-Directed Programming and Additivity</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.5">
          <fo:bookmark-title>2.5  Systems with Generic Operations</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.5.1">
          <fo:bookmark-title>2.5.1  Generic Arithmetic Operations</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.5.2">
          <fo:bookmark-title>2.5.2  Combining Data of Different Types</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_2.5.3">
          <fo:bookmark-title>2.5.3  Example: Symbolic Algebra</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_3">
          <fo:bookmark-title>3  Modularity, Objects, and State</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.1">
          <fo:bookmark-title>3.1  Assignment and Local State</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.1.1">
          <fo:bookmark-title>3.1.1  Local State Variables</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.1.2">
          <fo:bookmark-title>3.1.2  The Benefits of Introducing Assignment</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.1.3">
          <fo:bookmark-title>3.1.3  The Costs of Introducing Assignment</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.2">
          <fo:bookmark-title>3.2  The Environment Model of Evaluation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.2.1">
          <fo:bookmark-title>3.2.1  The Rules for Evaluation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.2.2">
          <fo:bookmark-title>3.2.2  Applying Simple Procedures</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.2.3">
          <fo:bookmark-title>3.2.3  Frames as the Repository of Local State</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.2.4">
          <fo:bookmark-title>3.2.4  Internal Definitions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.3">
          <fo:bookmark-title>3.3  Modeling with Mutable Data</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.3.1">
          <fo:bookmark-title>3.3.1  Mutable List Structure</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.3.2">
          <fo:bookmark-title>3.3.2  Representing Queues</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.3.3">
          <fo:bookmark-title>3.3.3  Representing Tables</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.3.4">
          <fo:bookmark-title>3.3.4  A Simulator for Digital Circuits</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.3.5">
          <fo:bookmark-title>3.3.5  Propagation of Constraints</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.4">
          <fo:bookmark-title>3.4  Concurrency: Time Is of the Essence</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.4.1">
          <fo:bookmark-title>3.4.1  The Nature of Time in Concurrent Systems</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.4.2">
          <fo:bookmark-title>3.4.2  Mechanisms for Controlling Concurrency</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.5">
          <fo:bookmark-title>3.5  Streams</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.5.1">
          <fo:bookmark-title>3.5.1  Streams Are Delayed Lists</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.5.2">
          <fo:bookmark-title>3.5.2  Infinite Streams</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.5.3">
          <fo:bookmark-title>3.5.3  Exploiting the Stream Paradigm</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.5.4">
          <fo:bookmark-title>3.5.4  Streams and Delayed Evaluation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_3.5.5">
          <fo:bookmark-title>3.5.5  Modularity of Functional Programs and Modularity of Objects</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_4">
          <fo:bookmark-title>4  Metalinguistic Abstraction</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1">
          <fo:bookmark-title>4.1  The Metacircular Evaluator</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1.1">
          <fo:bookmark-title>4.1.1  The Core of the Evaluator</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1.2">
          <fo:bookmark-title>4.1.2  Representing Expressions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1.3">
          <fo:bookmark-title>4.1.3  Evaluator Data Structures</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1.4">
          <fo:bookmark-title>4.1.4  Running the Evaluator as a Program</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1.5">
          <fo:bookmark-title>4.1.5  Data as Programs</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1.6">
          <fo:bookmark-title>4.1.6  Internal Definitions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.1.7">
          <fo:bookmark-title>4.1.7  Separating Syntactic Analysis from Execution</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.2">
          <fo:bookmark-title>4.2  Variations on a Scheme -- Lazy Evaluation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.2.1">
          <fo:bookmark-title>4.2.1  Normal Order and Applicative Order</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.2.2">
          <fo:bookmark-title>4.2.2  An Interpreter with Lazy Evaluation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.2.3">
          <fo:bookmark-title>4.2.3  Streams as Lazy Lists</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.3">
          <fo:bookmark-title>4.3  Variations on a Scheme -- Nondeterministic Computing</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.3.1">
          <fo:bookmark-title>4.3.1  Amb and Search</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.3.2">
          <fo:bookmark-title>4.3.2  Examples of Nondeterministic Programs</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.3.3">
          <fo:bookmark-title>4.3.3  Implementing the</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.4">
          <fo:bookmark-title>4.4  Logic Programming</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.4.1">
          <fo:bookmark-title>4.4.1  Deductive Information Retrieval</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.4.2">
          <fo:bookmark-title>4.4.2  How the Query System Works</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.4.3">
          <fo:bookmark-title>4.4.3  Is Logic Programming Mathematical Logic?</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_4.4.4">
          <fo:bookmark-title>4.4.4  Implementing the Query System</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_5">
          <fo:bookmark-title>5  Computing with Register Machines</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.1">
          <fo:bookmark-title>5.1  Designing Register Machines</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.1.1">
          <fo:bookmark-title>5.1.1  A Language for Describing Register Machines</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.1.2">
          <fo:bookmark-title>5.1.2  Abstraction in Machine Design</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.1.3">
          <fo:bookmark-title>5.1.3  Subroutines</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.1.4">
          <fo:bookmark-title>5.1.4  Using a Stack to Implement Recursion</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.1.5">
          <fo:bookmark-title>5.1.5  Instruction Summary</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.2">
          <fo:bookmark-title>5.2  A Register-Machine Simulator</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.2.1">
          <fo:bookmark-title>5.2.1  The Machine Model</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.2.2">
          <fo:bookmark-title>5.2.2  The Assembler</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.2.3">
          <fo:bookmark-title>5.2.3  Generating Execution Procedures for Instructions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.2.4">
          <fo:bookmark-title>5.2.4  Monitoring Machine Performance</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.3">
          <fo:bookmark-title>5.3  Storage Allocation and Garbage Collection</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.3.1">
          <fo:bookmark-title>5.3.1  Memory as Vectors</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.3.2">
          <fo:bookmark-title>5.3.2  Maintaining the Illusion of Infinite Memory</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.4">
          <fo:bookmark-title>5.4  The Explicit-Control Evaluator</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.4.1">
          <fo:bookmark-title>5.4.1  The Core of the Explicit-Control Evaluator</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.4.2">
          <fo:bookmark-title>5.4.2  Sequence Evaluation and Tail Recursion</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.4.3">
          <fo:bookmark-title>5.4.3  Conditionals, Assignments, and Definitions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.4.4">
          <fo:bookmark-title>5.4.4  Running the Evaluator</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5">
          <fo:bookmark-title>5.5  Compilation</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5.1">
          <fo:bookmark-title>5.5.1  Structure of the Compiler</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5.2">
          <fo:bookmark-title>5.5.2  Compiling Expressions</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5.3">
          <fo:bookmark-title>5.5.3  Compiling Combinations</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5.4">
          <fo:bookmark-title>5.5.4  Combining Instruction Sequences</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5.5">
          <fo:bookmark-title>5.5.5  An Example of Compiled Code</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5.6">
          <fo:bookmark-title>5.5.6  Lexical Addressing</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_sec_5.5.7">
          <fo:bookmark-title>5.5.7  Interfacing Compiled Code to the Evaluator</fo:bookmark-title>
        </fo:bookmark>
        <fo:bookmark internal-destination="toc_chap_Temp_849">
          <fo:bookmark-title>References</fo:bookmark-title>
        </fo:bookmark>
      </fo:bookmark-tree>
      <fo:page-sequence master-reference="default">
        <fo:static-content flow-name="xsl-footnote-separator">
          <fo:block>
            <fo:leader leader-pattern="rule"
                       leader-length="100%"
                       rule-style="solid"
                       rule-thickness="0.5pt"/>
          </fo:block>
        </fo:static-content>
        <fo:flow font-size="10" flow-name="xsl-region-body">
          <xsl:apply-templates select="/xhtml:html/xhtml:body"></xsl:apply-templates>
        </fo:flow>                
      </fo:page-sequence>
    </fo:root>
  </xsl:template>

  <xsl:template match="xhtml:p[preceding-sibling::*[1]/@class='chapterheading']">
    <xsl:variable name="link" select="substring-after(xhtml:a/@href, '#')" />
    <fo:block margin="0.5em" font-weight="bold" font-size="12">
      <xsl:if test="$link">
        <xsl:attribute name="id"><xsl:value-of select="$link" /></xsl:attribute>
      </xsl:if>
      <fo:inline><xsl:value-of select="."/></fo:inline>
    </fo:block>
  </xsl:template>
  
  <xsl:template match="xhtml:h1">
    <fo:block break-before="page" margin="1em" font-weight="bold" font-size="14">
      <fo:inline><xsl:value-of select="."/></fo:inline>
    </fo:block>
  </xsl:template>

  <xsl:template match="xhtml:h2">
    <xsl:variable name="link" select="substring-after(xhtml:a/@href, '#')" />
    <fo:block margin="1em" font-weight="bold" font-size="14">
      <xsl:if test="$link">
        <xsl:attribute name="id"><xsl:value-of select="$link" /></xsl:attribute>
      </xsl:if>
      <fo:inline><xsl:value-of select="."/></fo:inline>
    </fo:block>
  </xsl:template>

  <xsl:template match="xhtml:h3">
    <xsl:variable name="link" select="substring-after(xhtml:a/@href, '#')" />
    <fo:block margin="0.5em" font-weight="bold" font-size="12">
      <xsl:if test="$link">
        <xsl:attribute name="id"><xsl:value-of select="$link" /></xsl:attribute>
      </xsl:if>
      <fo:inline><xsl:value-of select="."/></fo:inline>
    </fo:block>
  </xsl:template>

  <xsl:template match="xhtml:h4">
    <fo:block margin="0.5em" font-weight="bold" font-size="12">
      <fo:inline><xsl:value-of select="."/></fo:inline>
    </fo:block>
  </xsl:template>

  <xsl:template match="xhtml:h5">
    <fo:block margin="0.5em" font-size="10">
      <fo:inline><xsl:value-of select="."/></fo:inline>
    </fo:block>
  </xsl:template>

  <xsl:template match="xhtml:p">
    <xsl:if test="normalize-space() != ''">
      <fo:block text-align="justify" margin-bottom="0.5em">
        <xsl:apply-templates select="text()|*" />
      </fo:block>
    </xsl:if>
  </xsl:template>

  <xsl:template match="xhtml:table">
    <fo:table table-layout="fixed" width="100%">
      <fo:table-body>
        <xsl:apply-templates select="*" />
      </fo:table-body>
    </fo:table>
  </xsl:template>

  <xsl:template match="xhtml:tr">
    <fo:table-row>
      <xsl:apply-templates select="*" />
    </fo:table-row>
  </xsl:template>

  <xsl:template match="xhtml:td">
    <fo:table-cell>
      <fo:block>
        <xsl:apply-templates select="*|text()" mode="block" />
      </fo:block>
    </fo:table-cell>
  </xsl:template>
  
  <xsl:template match="xhtml:a[starts-with(@href, '#footnote_')]">
    <fo:footnote>
      <fo:inline baseline-shift="super" font-size="6"><xsl:value-of select=".//text()"/></fo:inline>
      <fo:footnote-body>
        <fo:block margin-left="0em" margin-right="0em" font-size="8">
          <xsl:apply-templates select="//xhtml:p[./xhtml:a[@id=substring(current()/@href,2)]]" mode="footnote"></xsl:apply-templates>
        </fo:block>
      </fo:footnote-body>
    </fo:footnote>
  </xsl:template>
  
  <xsl:template match="xhtml:a[starts-with(@href, '#footnote_')]" mode="footnote">
    <fo:inline baseline-shift="super" font-size="6"><xsl:value-of select=".//text()"/></fo:inline>
  </xsl:template>

  
  <xsl:template match="xhtml:ul|xhtml:ol">
    <fo:block margin-left="0.5em" margin-right="0.5em" margin-bottom="0.5em">
      <xsl:apply-templates select="*" />
    </fo:block>
  </xsl:template>
  
  <xsl:template match="xhtml:blockquote">
    <fo:block margin-left="0.5em" margin-right="0.5em">
      <xsl:apply-templates select="text()|*" />
    </fo:block>
  </xsl:template>
  
  <xsl:template match="xhtml:li">
    <fo:block margin-bottom="0.5em">
      <xsl:apply-templates select="text()|*" />
    </fo:block>
  </xsl:template>
  
  <xsl:template match="xhtml:tt">
    <fo:inline font-family="Courier" font-weight="bold" font-size="8"><xsl:value-of select="."/></fo:inline>
  </xsl:template>
  
  <xsl:template match="xhtml:tt[count(descendant::xhtml:br) > 0]">
    <fo:block font-family="Courier" font-weight="bold" font-size="8" white-space="pre">
      <xsl:apply-templates select="text()|*"></xsl:apply-templates>
    </fo:block>
  </xsl:template>

  <xsl:template match="xhtml:img" mode="block">
    <fo:external-graphic width="100%"
                         content-width="scale-to-fit"
                         scaling="uniform" 
                         content-height="100%" src="url('{@src}')"/>
  </xsl:template>

  <xsl:template match="xhtml:img">
    <!--
        <xsl:choose>
        <xsl:when test="@src='book-Z-G-D-3.gif'"><fo:inline font-family="Symbol">&#x0398;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-4.gif'"><fo:inline font-family="Symbol">&#x03D1;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-6.gif'"><fo:inline font-family="Symbol">&#x03BB;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-9.gif'"><fo:inline font-family="Symbol">&#x03C0;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-11.gif'"><fo:inline font-family="Symbol">&#x03C6;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-12.gif'"><fo:inline font-family="Symbol">&#x03C8;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-13.gif'"><fo:inline font-family="Symbol">&#x221A;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-14.gif'"><fo:inline font-family="Symbol">&#x2190;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-15.gif'"><fo:inline font-family="Symbol">&#x2192;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-16.gif'"><fo:inline font-family="Symbol">&#x2191;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-17.gif'"><fo:inline font-family="Symbol">&#x21A6;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-18.gif'"><fo:inline font-family="Symbol">&#x22EE;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-19.gif'"><fo:inline font-family="Symbol">&#x222B;</fo:inline></xsl:when>
        <xsl:when test="@src='book-Z-G-D-20.gif'"><fo:inline font-family="Symbol">&#x2248;</fo:inline></xsl:when>
    -->
    <fo:external-graphic src="url('{@src}')"
                         content-height="1em" content-width="1em"/>

  </xsl:template>

  <xsl:template match="xhtml:div[.//descendant::xhtml:span[@class='epigraph']]" priority="2">
    <fo:block margin-left="2em" margin-right="2em">
      <xsl:apply-templates select="xhtml:table/xhtml:tr/xhtml:td/*" />
    </fo:block>
  </xsl:template>
  
  <xsl:template name="figure">
    <fo:block margin-left="0.5em" margin-right="0.5em" margin-bottom="1em" margin-top="1em" font-size="8" keep-with-next.within-column="always">
      <xsl:apply-templates select="xhtml:div/*|xhtml:div/text()" />
    </fo:block>
    <xsl:apply-templates select="xhtml:table" />
  </xsl:template>
  
  <xsl:template match="xhtml:div">
    <xsl:choose>
      <xsl:when test="starts-with(xhtml:div/xhtml:strong/text(), 'Figure')">
        <xsl:call-template name="figure" />
      </xsl:when>
      <xsl:when test="./xhtml:img[@src='cover.jpg']">
        <fo:block>
          <fo:external-graphic content-height="200%" content-width="200%" src="url('cover.jpg')"/>
        </fo:block>        
      </xsl:when>
      <xsl:when test="./xhtml:img">
        <fo:block text-align="center">
          <xsl:apply-templates select="*|text()" mode="block" />
        </fo:block>
      </xsl:when>
      <xsl:otherwise>
        <fo:block>
          <xsl:apply-templates select="*|text()"></xsl:apply-templates>
        </fo:block>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="xhtml:sup">
    <fo:inline baseline-shift="super" font-size="6"><xsl:value-of select=".//text()"/></fo:inline> 
  </xsl:template>

  <xsl:template match="xhtml:sub">
    <fo:inline baseline-shift="sub" font-size="6"><xsl:value-of select=".//text()"/></fo:inline> 
  </xsl:template>
  
  <xsl:template match="xhtml:strong">
    <fo:inline font-weight="bold"><xsl:apply-templates select="text()|*" /></fo:inline>
  </xsl:template>
  
  <xsl:template match="xhtml:em">
    <fo:inline font-style="italic"><xsl:apply-templates select="text()|*" /></fo:inline>
  </xsl:template>

  <xsl:template match="xhtml:u">
    <fo:inline text-decoration="underline"><xsl:apply-templates select="text()|*" /></fo:inline>
  </xsl:template>
  
  <xsl:template match="xhtml:div[@class='navigation']" />    
  <xsl:template match="xhtml:div[@class='footnote']" />    

  <xsl:template match="text()" >
    <xsl:value-of select="."/>
  </xsl:template>
</xsl:stylesheet>
